﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3
#pragma hide=1

// ***
// DISPLAY FUNCTIONS
// create image window
// show an image
// show histograms window
// append image tools panel
// set panel side
// initialize tab menus
// (reset image file on panel)
// set hook functions
// update control bar
// show Tab M
// switch tabs
// split window
// update Tab M
// update info
// update panel controls

// create image window
Function disp_CreateImageWindow(LoR)
	variable LoR

	// globals for package	
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	wave/SDFR=pf/Z scalewx, scalewy, scaledx
	
	string stitle, fstr, tstr
	variable lpos = LoR*pwidth
	variable nimgs = f_NImagesLoaded()
	
	// set the folder and image
	fstr = "root:" + cwdfolder
	DFREF imgF = $fstr	
	wave/SDFR=imgF itd = $cwfile

	variable bd = f_ImageBitDepth()
	
	STRUCT S_ImgWinSize siws
	Sf_GetImgWinSize(siws)
	
	PauseUpdate
	
	NewImage/K=1/N=$k_imgDisplay itd
	DoWindow/T $k_imgDisplay,"Images"
	MoveWindow/W=$k_imgDisplay siws.left+lpos, siws.top, siws.right, siws.bottom
	ModifyImage/W=$k_imgDisplay $cwfile, explicit=0
	ModifyGraph/W=$k_imgDisplay width={Plan,1,top,left}
	// set grayscale range
	switch(bd)
		case 8:
		case 12:
		case 16:
			bd = (2^bd) - 1
			ModifyImage/W=$k_imgDisplay $cwfile, ctab={0,bd,Grays,0}
			break
		default:
			ModifyImage/W=$k_imgDisplay $cwfile, ctab={0,*,Grays,0}
			break
	endswitch
	
	disp_AddControlBar()	
	DoUpdate/W=$k_imgDisplay
	
	return 0
end

Static Function disp_AddControlBar()

	// add control bar

	ControlBar cbheight
	
	DefaultGuiFont/W=# all={"_IgorSmall",10,0}, button={"_IgorMedium",12,0}

	Button buttonExpand_CB, pos={15,4}, size={30,20}, title="...", proc=X_ButtonProc, userData(state)="0", userData(size)="0", help={"Set expansion of image window.\rShift key sets a preferred size."}
	CheckBox checkInvert_CB,pos={80,4},size={20,20},title="Invert",value=0,proc=X_CheckProc, help={"Invert the image color scale."}
	
	PopupMenu popupColor_CB, pos={5,25},size={80,20},title="", help={"Choose a color scaling."}
	PopupMenu popupColor_CB, mode=1, value=CTabList(), proc=X_PopMenuProc
	
	Slider sliderIMin_CB, pos={155,2},size={105,20},vert=0,limits={0,0.5,0.02},value=0,proc=X_SliderProc
	Button buttonResetIRange_CB, pos={260,3},size={40,22},title="<-->",proc=X_ButtonProc, help={"Expand intensity range to full scale."}
	CheckBox checkMaxRange_CB,pos={265,30},size={20,20},title="*",value=0,proc=X_CheckProc, help={"Use image full scale rather than 8-bit full scale."}
	Slider sliderIMax_CB, pos={300,2},size={130,20},vert=0,limits={0.5,1.3,0.02},value=1,proc=X_SliderProc
	
	Button buttonswap_CB, pos={426,8}, size={18,cbheight-16}, fSize=10, title="↑\r↓", proc=x_ButtonProc, disable=1, help={"Swap"}
	SetVariable setvarCurrImg_CB, pos={450,5},size={120,20},title="",value=_STR:"", disable=2
	PopupMenu popupSplit_CB, pos={450,25},size={80,20},title="Split", help={"Show two images side-by-side."}
	PopupMenu popupSplit_CB, mode=1, value=f_SplitOptions(), proc=X_PopMenuProc
	
	CheckBox checkNumbers_CB, pos={300,30}, size={20,20},title="#",value=0,proc=X_CheckProc, help={"Use numbers not sliders."}
	SetVariable setvarImin_CB, pos={180,5}, size={100,20}, fSize=12, title="min:", value=_NUM:0, proc=X_SetVarProc, help={"Set minimum"}, disable=1
	SetVariable setvarImax_CB, pos={320,5}, size={100,20}, fSize=12, title="max:", value=_NUM:255, proc=X_SetVarProc, help={"Set minimum"}, disable=1

	Button buttonSplitRoB_CB, pos={580,5}, fSize=10, size={18,15}, title="v", proc=x_ButtonProc, userdata(mode)="1", disable=0, help={"Split right or bottom"}
	return 0
end

Function disp_ShowHideCBNumbers(variable how)

	variable smin, smax, bd, dmax
	bd = f_ImageBitDepth()
	ControlInfo/W=$k_imgDisplay checkMaxRange_CB
	if (v_value)
		dmax = f_DisplayedImageMax()
	else
		dmax = 2^bd - 1
	endif
	switch(how)
		case 0:		// hide -- change to slider
			smin = Get_DisImageMinMax(-1, 1)/dmax
			smax = Get_DisImageMinMax(1, 1)/dmax
			SetVariable setvarImin_CB, win=$k_imgDisplay, disable=1
			SetVariable setvarImax_CB, win=$k_imgDisplay, disable=1
			Slider sliderIMin_CB, win=$k_imgDisplay, disable=0, value=smin
			Slider sliderIMax_CB, win=$k_imgDisplay, disable=0, value=smax
			CheckBox checkMaxRange_CB, win=$k_imgDisplay, disable=0
			Button buttonResetIRange_CB, win=$k_imgDisplay, disable=0
			break
		case 1:		// show -- use numbers
			smin = Get_DisImageMinMax(-1, 0)
			smax = Get_DisImageMinMax(1, 0)
			SetVariable setvarImin_CB, win=$k_imgDisplay, disable=0, value=_NUM:smin
			SetVariable setvarImax_CB, win=$k_imgDisplay, disable=0, value=_NUM:smax
			Slider sliderIMin_CB, win=$k_imgDisplay, disable=1
			Slider sliderIMax_CB, win=$k_imgDisplay, disable=1
			CheckBox checkMaxRange_CB, win=$k_imgDisplay, disable=1
			Button buttonResetIRange_CB, win=$k_imgDisplay, disable=1
			break	
	endswitch
//	change_ImageBitDepth(2)
	return 0
end

// show histograms
// how = 0 new, 1 replace traces
Function disp_ShowHistograms(variable how)

	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	string workf = "root:" + cwdfolder
	DFREF wf = $workf

	variable dhmin, dhmax, xmid, xend
	string imgroot, iHwave, iCHwave, iDHwave, dhistlimits
	string alltraces, htracen, htracel, ctrace, dtrace
	
	// regenerate the histogram each time this is called
	ControlInfo/W=$k_fullpanel popupHistRoI_tabM
	if (v_flag == 0)
		generate_Histograms(0)
	else	
		generate_Histograms(v_value - 1)
	endif
	
	workf += ":" + k_histFolder
	DFREF hf = $workf
	
	imgroot = StringFromList(1,cwfile,"_")
	iHwave = "hist_" + imgroot
	iCHwave = "chist_" + imgroot
	iDHwave = "dhist_" + imgroot
	
	wave/SDFR=hf theH = $iHwave
	wave/SDFR=hf theCH = $iCHwave
	wave/SDFR=hf theDH = $iDHwave
	
	WaveStats/Q theDH
	dhmax = v_max
	dhmin = v_min
	sprintf dhistlimits, "%d,%d",dhmin,dhmax
	
	// how = 0 is new; how = 1 is replace
	switch(how)
		case 0:		// new
			KillWindow/Z $k_histGraphs
			Display/N=$k_histGraphs/W=(wleft,wtop+1.06*pheight,gwidth,wtop+1.06*pheight+0.25*gwidth)/K=2 as "Histograms"
			AutoPositionWindow/E/M=1/R=$k_imgDisplay $k_histGraphs
			ModifyGraph/W=$k_histGraphs height={Aspect,0.25}
			AppendtoGraph/W=$k_histGraphs/R=lhist theH
			htracel = StringFromList(0,TraceNameList("",";",1))
			AppendtoGraph/W=$k_histGraphs/L=nhist theH
			htracen = StringFromList(1,TraceNameList("",";",1))
			AppendToGraph/W=$k_histGraphs/L=chist theCH
			ctrace = StringFromList(2,TraceNameList("",";",1))
			AppendtoGraph/W=$k_histGraphs/R=dhist theDH
			dtrace = StringFromList(3,TraceNameList("",";",1))
			xend = numpnts(theDH) - 1
			xmid = round(numpnts(theDH)/2)

			Button buttonhelp_hist title="?",size={20,20},pos={10,15}, proc=X_ButtonProc,fSize=10,help={"Get an explanation of the plots in this window."}

			ModifyGraph/W=$k_histGraphs rgb=(52428,1,1),lsize=2,standoff=0
			ModifyGraph/W=$k_histGraphs rgb($htracen)=(1,4,52428), rgb($ctrace)=(1,4,52428)
			ModifyGraph/W=$k_histGraphs log(lhist)=1,freePos(chist)={0,bottom},freePos(dhist)={inf,bottom}
			ModifyGraph/W=$k_histGraphs noLabel(lhist)=2,noLabel(lhist)=2,nticks(nhist)=0,nticks(nhist)=0,tick(lhist)=3
			ModifyGraph/W=$k_histGraphs noLabel(chist)=2,noLabel(dhist)=2,nticks(chist)=0,nticks(dhist)=0,zero(dhist)=2
			ModifyGraph/W=$k_histGraphs mode($htracen)=1,mode($htracel)=1,lsize($htracen)=1,lsize($htracel)=1
			ModifyGraph/W=$k_histGraphs freePos(lhist)={inf,bottom},freePos(nhist)={0,bottom}
			ModifyGraph/W=$k_histGraphs axisEnab(nhist)={0,0.5},axisEnab(lhist)={0,0.5},noLabel(nhist)=2
			ModifyGraph/W=$k_histGraphs axisEnab(chist)={0.51,1},axisEnab(dhist)={0.51,1}
			ModifyGraph/W=$k_histGraphs tick(bottom)=1,noLabel(bottom)=2
			Cursor/W=$k_histGraphs A $dtrace, xmid
			Cursor/W=$k_histGraphs/P/S=2/L=1/H=2/N=1/A=0 C $dtrace, 0
			Cursor/W=$k_histGraphs/P/S=2/L=1/H=2/N=1/A=0 D $dtrace, xend
			DoUpdate/W=$k_histGraphs
			ControlInfo/W=$k_fullpanel slidermagdhist_tabM
			scale_DHistogram(v_value)
			break
		case 1:		// just replace waves
			alltraces = SortList(TraceNameList(k_histGraphs,";",1))
			if (strlen(alltraces)==0)
				return -1
			endif
			// alphabetical sort: c, d, h
			ctrace = StringFromList(0,alltraces)
			ReplaceWave/W=$k_histGraphs trace=$ctrace, theCH
			dtrace = StringFromList(1,alltraces)
			ReplaceWave/W=$k_histGraphs trace=$dtrace, theDH
			htracel = StringFromList(3,alltraces)
			ReplaceWave/W=$k_histGraphs trace=$htracel, theH
			htracen = StringFromList(2,alltraces)
			ReplaceWave/W=$k_histGraphs trace=$htracen, theH
			//DoUpdate
			if (strlen(CsrInfo(A,k_histGraphs))==0)
				ValDisplay valdispcx_tabM, win=$k_fullpanel, value=_NUM:NaN
				ValDisplay valdispcy_tabM, win=$k_fullpanel, value=_NUM:NaN
			else
				ValDisplay valdispcx_tabM, win=$k_fullpanel, value=_NUM:xcsr(A,k_histGraphs)
				ValDisplay valdispcy_tabM, win=$k_fullpanel, value=_NUM:vcsr(A,k_histGraphs)
			endif
			// scale the histogram according to slider
			ControlInfo/W=$k_fullpanel slidermagdhist_tabM
			scale_DHistogram(v_value)
			AutoPositionWindow/E/M=1/R=$k_imgDisplay $k_histGraphs
			DoUpdate/W=$k_histGraphs
			break
	endswitch
	SetWindow $k_histGraphs userdata(dhistogram)=dhistlimits
	
	return 0
end

// append the panel
Function disp_AppendImageToolsPanel(LoR)
	variable LoR

	DFREF pf=$k_fullpackageFolder
	NVAR/SDFR=pf k_imgTVersion
	
	string kstrv
	sprintf kstrv, "%3.2f", k_imgTVersion
	
	// panel frame
	DoWindow/F $k_imgDisplay
	switch(LoR)
		case 0:
			NewPanel/EXT=(LoR)/HOST=$k_imgDisplay/W=(0,0,pwidth,pheight)/N=$k_panelName/K=1 as "Image Tools Panel"
			break
		case 1:
			NewPanel/EXT=(LoR)/HOST=$k_imgDisplay/W=(pwidth,0,0,pheight)/N=$k_panelName/K=1 as "Image Tools Panel"
			break
	endswitch
#ifndef DEBUG
	ModifyPanel/W=$k_fullpanel fixedSize=1, noEdit=1
#endif
	
	DefaultGuiFont/W=# all={"_IgorSmall",10,0}, button={"_IgorMedium",12,0}
	DefaultGuiFont/W=# tabcontrol={"_IgorMedium",14,0}, panel={"_IgorMedium",12,0}
	
	// version information
	SetDrawEnv fsize=9
	DrawText pwidth-40,15,"v: " + kstrv
	
	// tab controls
	
	TabControl tab_main,pos={0,ptabpos},size={pwidth,pheight-ptabpos},proc=X_TabProc

	TabControl tab_main,tabLabel(0)="Load"
	TabControl tab_main,tabLabel(1)="Calibrate"
	TabControl tab_main,tabLabel(2)="Process"
	TabControl tab_main,tabLabel(3)="Publish"
//	TabControl tab_main,tabLabel(4)="Admin"
	
	// call to each tab in its own procedure file
//	disp_Tab4Draw(pwidth,pheight,ptabpos)
	disp_Tab3Draw(pwidth,pheight,ptabpos)
	disp_Tab2Draw(pwidth,pheight,ptabpos)
	disp_Tab1Draw(pwidth,pheight,ptabpos)
	disp_Tab0Draw(pwidth,pheight,ptabpos)
	disp_TabMDraw()
	
	return 0
end

// put the panel left or right
Function disp_SetImagePanelSide(variable LoR)
	
	STRUCT S_ControlBarSettings scb
	
	if (f_IsSplit())
		return -1
	endif
	
	Sf_GetControlBarSettings(scb)		
	DoWindow/K $k_imgDisplay
	disp_CreateImageWindow(LoR)
	disp_ShowHistograms(0)
	disp_AppendImageToolsPanel(LoR)
	DoUpdate
	Sf_RestoreControlBarSettings(scb)
	restore_ImageSettings(scb)
	disp_SetHookFunctions()	
	
	switch(LoR)
		case 0:		// left
			Button buttonImgL_tabM, win=$k_fullPanel, disable=2
			Button buttonImgR_tabM, win=$k_fullPanel, disable=0
			break
		case 1:	// right
			Button buttonImgL_tabM, win=$k_fullPanel, disable=0
			Button buttonImgR_tabM, win=$k_fullPanel, disable=2
			break
	endswitch
	
	return 0
end

// initialize menu options for a given tab
Function disp_InitializeTabMenus(tab)
	variable tab
	
	DFREF pf=$k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
#ifdef DEBUG
	print "initializing tab ", tab
#endif

	switch(tab)
		case -1:		// initialize package
			PopupMenu/Z popupfolder_tabM, win=$k_fullpanel, disable = 1
			PopupMenu/Z popupfile_tabM, win=$k_fullpanel, disable = 1
			Button/Z buttonleft_tabM, win=$k_fullpanel, disable = 1
			Button/Z buttonright_tabM, win=$k_fullpanel, disable = 1
			break
		case 1:
			break
		case 100:		// images exist so reset
			set_ImagetoShow(cwdfolder, cwfile)
			PopupMenu/Z popupfolder_tabM, win=$k_fullpanel, disable = 0
			PopupMenu/Z popupfile_tabM, win=$k_fullpanel, disable = 0
			reset_ImageFileonPanel()
			disp_UpdateTabM()
			break
	endswitch
	
	return 0
end

// set all window hook functions
Function disp_SetHookFunctions()

	SetWindow $k_imgDisplay, hook(imgTImageHook)=Hf_imgTImageHook
	SetWindow $k_histGraphs, hook(imgTHistHook)=Hf_imgTHistogramsHook
	SetWindow $k_panelName, hook(imgTPanelHook)=Hf_imgTPanelHook

	return 0
end

// update control bar
Function disp_UpdateControlBar([variable allstate])

	variable isstack, vmode
	string cimgstr, sostr
	
	if (!ParamIsDefault(allstate))
		cimgstr = ControlNameList(k_imgDisplay)
		ModifyControlList cimgstr win=$k_imgDisplay, disable=allstate
		if (allstate==1)
			return 0
		endif
	endif
	
	isstack = f_IsStack()
	cimgstr = ReplaceString("img_",f_CurrentImage(),"")
	if (f_ImageBitDepth() != 8)
		Checkbox checkMaxRange_CB, win=$k_imgDisplay, value=1, disable=2
	else
		Checkbox checkMaxRange_CB, win=$k_imgDisplay, disable=0
	endif
	SetVariable setvarCurrImg_CB, win=$k_imgDisplay, value=_STR:cimgstr, disable=2
	if (f_IsSplit())
		cimgstr = ReplaceString("img_",StringFromList(1,ImageNameList(k_imgDisplay,";")),"")
		sostr = f_SplitOptions()
		vmode = WhichListItem(cimgstr,sostr) + 1
		Button buttonswap_CB, win=$k_imgDisplay, disable=0
		Button buttonsplitRoB_CB, win=$k_imgDisplay, disable=2
	else
		Button buttonswap_CB, win=$k_imgDisplay, disable=1
		Button buttonsplitRoB_CB, win=$k_imgDisplay, disable=0
		vmode = 1
	endif
	PopupMenu popupSplit_CB, win=$k_imgDisplay, value=f_SplitOptions(), mode=vmode
	return 0
end

// draw tabMAIN
Function disp_TabMDraw()

	variable tvoffset = 10
	variable nimgs = 0, nstacks = 1
	variable dtvoffset = 30
	
	// tab MAIN - common to all
	
	// Display Image Section
	
	TitleBox display_tabM, pos={15,tvoffset},size={122,22},title="Image Displayed"
	TitleBox display_tabM,fSize=16,frame=0,fStyle=1
	
	nimgs = f_NImagesLoaded()
	nstacks = f_NImagesInStack()

	// current image information
	
	tvoffset += 0.8*dtvoffset
	
	if (nimgs > 1)
		Button buttonleft_tabM title="<",pos={15,tvoffset},size={20,20},proc=X_ButtonProc,disable=2
		Button buttonright_tabM title=">",pos={35,tvoffset},size={20,20},proc=X_ButtonProc,disable=0
	else
		Button buttonleft_tabM title="<",pos={15,tvoffset},size={20,20},proc=X_ButtonProc,disable=2
		Button buttonright_tabM title=">",pos={35,tvoffset},size={20,20},proc=X_ButtonProc,disable=2
	endif
	Button buttonleft_tabM, help={"move leftward/backward in folder set"}
	Button buttonright_tabM, help={"move rightward/forward in folder set"}

	// folder
	
	PopupMenu popupfolder_tabM,title="Folder",mode=1,value= #"f_LoimgT()",fSize=12
	PopupMenu popupfolder_tabM,align=0,pos={60,tvoffset},proc=X_PopMenuProc
	PopupMenu popupfolder_tabM help={"Select a folder for image display"}
	
	// movie
	
	Button buttondoMovie_tabM, pos={pwidth-125,tvoffset+8}, size={30,20}, proc=X_ButtonProc
	Button buttondoMovie_tabM, title="🎥", disable=(nstacks<1),font="Symbol", fSize=10
	Button buttondoMovie_tabM, help={"Show a movie of the stack."}
		
	SetVariable setvarsleep_tabM, title="sleep",pos={pwidth-90,tvoffset+10},size={75,20},proc=X_SetVarProc
	SetVariable setvarsleep_tabM, limits={0,100,10}, disable=(nstacks<1), value=_NUM:10
	SetVariable setvarsleep_tabM, help={"Increase this value to slow down the movie speed."}
	
	tvoffset += dtvoffset
	
	// image + stack
	
	PopupMenu popupfile_tabM,pos={15,tvoffset},size={106,23},proc=X_PopMenuProc
	PopupMenu popupfile_tabM,mode=1,value= #"f_LoimgF()",title="Image",fSize=12
	PopupMenu popupfile_tabM, help={"Choose the file to display in the main (left) panel."}
		
	SetVariable setvarSN_TabM, title="stack",pos={pwidth-145,tvoffset+2},size={80,20},proc=X_SetVarProc,fSize=10
	SetVariable setvarSN_TabM, limits={0,nimgs-1,1}, value=_NUM:0, disable=(nstacks<1)

	ValDisplay valdispNPlanes_TabM, title="/",pos={pwidth-60,tvoffset+2},size={40,20}
	ValDisplay valdispNPlanes_TabM, value=_NUM:(nimgs-1), disable=(nstacks<1)
	
	// size + bitdepth
	
	tvoffset += 0.8*dtvoffset

	SetVariable setvarSize_tabM,pos={15,tvoffset+2},title="Size",size={280,20}
	SetVariable setvarSize_tabM,value=_STR:f_ImageSizeText(),noedit=1,fSize=12
		
	PopupMenu popupBitDepth_tabM,mode=(f_PBitDepth()),value=#"f_LoBitDepths()",fSize=12
	PopupMenu popupBitDepth_tabM, align=0,pos={pwidth-95,tvoffset},title="Depth", proc=X_PopMenuProc

	// notes
	
	tvoffset += 0.8*dtvoffset
	
	SetVariable setvarImgNote_tabM,pos={15,tvoffset},title="Notes",size={380,20}
	SetVariable setvarImgNote_tabM,value=_STR:f_ImageNoteText(), proc=X_SetVarProc
	
	tvoffset += 0.8*dtvoffset
	
	SetDrawEnv linefgc=(30583,30583,30583),fillpat=0,dash=2
	DrawLine/W=$k_fullpanel 0,tvoffset,pwidth,tvoffset

	// Information Control Section
	
	tvoffset += 0.25*dtvoffset

	TitleBox infodisplay_tabM,pos={15,tvoffset},size={122,22},title="Display Information"
	TitleBox infodisplay_tabM,fSize=16,frame=0,fStyle=1,disable=0

	tvoffset += 0.8*dtvoffset

	// image intensity ranges
	
	TitleBox iDisplay_tabM,pos={15,tvoffset}, size={100,22}, title="Image",fSize=12,frame=0
	
	ValDisplay imin_tabM, title="min",pos={90,tvoffset},format="%6.4g", size={70,20},value=_NUM:NaN
	ValDisplay imax_tabM, title="max",pos={170,tvoffset},format="%6.4g",size={70,20},value=_NUM:NaN
	ValDisplay iave_tabM, title="ave",pos={250,tvoffset},format="%6.4g",size={70,20},value=_NUM:NaN
	ValDisplay istd_tabM, title="std",pos={330,tvoffset},format="%6.2g",size={68,20},value=_NUM:NaN	

	// ROI
	
	tvoffset += 0.8*dtvoffset
	
	PopupMenu popupHistRoI_tabM title="RoI",pos={15,tvoffset},fSize=12,size={60,20}
	PopupMenu popupHistRoI_tabM value=#"f_LoHMRoI()",proc=X_PopMenuProc, userdata="Full Image"
	PopupMenu popupHistRoI_tabM help={"Choose a region of interest (RoI) to perform image analysis.\rFull, Inside, Outside, or Differences."}
	
	// Marquee
	
	tvoffset += 0.75*dtvoffset

	TitleBox marqueeHeader_tabM,pos={20,tvoffset},size={122,22},title="Marquee",fSize=12,frame=0
	
	SetVariable mqx0_tabM, title="<",pos={90,tvoffset},size={70,20},value=_NUM:NaN,proc=X_SetVarProc, disable=2
	SetVariable mqdx_tabM, title="-",pos={163,tvoffset},size={70,20},value=_NUM:NaN,proc=X_SetVarProc, disable=2
	SetVariable mqy0_tabM, title="^",pos={250,tvoffset},size={70,20},value=_NUM:NaN,proc=X_SetVarProc, disable=2
	SetVariable mqdy_tabM, title="|",pos={323,tvoffset},size={70,20},value=_NUM:NaN,proc=X_SetVarProc, disable=2

	CheckBox checklockhRoI_tabM,pos={20,tvoffset+12},size={20,20},title="lock",disable=2
	CheckBox checklockhRoI_tabM,fSize=10,value=0,proc=X_CheckProc,userdata(state)="2"

	tvoffset += dtvoffset

	ValDisplay roimin_tabM, title="min",pos={10,tvoffset},size={70,20},format="%6.4g",value=_NUM:NaN
	ValDisplay roimax_tabM, title="max",pos={90,tvoffset},size={70,20},format="%6.4g",value=_NUM:NaN
	ValDisplay roiave_tabM, title="ave",pos={170,tvoffset},size={70,20},format="%6.4g",value=_NUM:NaN
	ValDisplay roistd_tabM, title="std",pos={250,tvoffset},size={68,20},format="%6.2g",value=_NUM:NaN
	ValDisplay roitotal_tabM, title="tot",pos={330,tvoffset},size={75,20},format="%0.3g",value=_NUM:NaN

	// Analysis

	tvoffset += 0.85*dtvoffset
	
	PopupMenu popupWhatInfo_tabM title="Analysis",pos={15,tvoffset},fSize=12,size={20,20}
	PopupMenu popupWhatInfo_tabM value=#"f_LoInfoOptions()",mode=2,proc=X_PopMenuProc
	PopupMenu popupWhatInfo_tabM help={"Choose the analysis information that is displayed about the image."}
	
	// scale derivative
		
	TitleBox histscale_tabM,pos={280,tvoffset+5},size={40,22},title="M"
	TitleBox histscale_tabM,fSize=10,frame=0

	Slider slidermagdhist_tabM pos={260,tvoffset+5},value=0,limits={0,3,0.2}
	Slider slidermagdhist_tabM proc=X_SliderProc,size={80,40},ticks=0, help={"Magnification of derivative from histogram."}

	TitleBox histogramcursor_tabM,pos={320,tvoffset},size={122,22},title="Cursor Reading",fSize=10,frame=0
	ValDisplay valdispcx_tabM pos={320,tvoffset+15}, title="bin",size={60,20},value=_NUM:xcsr(A,k_histgraphs),fSize=10, help={"Bin position on histogram."}
	ValDisplay valdispcy_tabM pos={320,tvoffset+35}, title="der",format="%3.3g", size={75,20},value=_NUM:vcsr(A,k_histgraphs),fSize=10, help={"Derivative at bin position."}

	tvoffset += 0.8*dtvoffset
	
	Button buttonRedoH_tabM,pos={20,tvoffset},size={50,25},proc=X_ButtonProc
	Button buttonRedoH_tabM,fSize=10,title="Refresh", help={"Force the analysis to recalculate.\rAlso brings the analysis window under the current image."}
	
	// panel position
	
	tvoffset += 1.2*dtvoffset

	Button buttonImgL_tabM, title="|<",pos={10,tvoffset},size={20,20},proc=X_ButtonProc, disable=2
	Button buttonImgR_tabM, title=">|",pos={pwidth-25,tvoffset},size={20,20},proc=X_ButtonProc, disable=0

	tvoffset += 0.7*dtvoffset
	
	CheckBox checkprintntbk_tabM,pos={pwidth-60,tvoffset},size={60,20}, title="report", fSize=10, value=0

	return 0
end

// switch tabs
Function disp_SwitchTab(string ptab, variable ctab)
	
#ifdef DEBUG
	print "Switching from tab to tab ", ptab, ctab
#endif
	
	variable nptab = str2num(ptab)
	string tabList, ctabstr=num2str(ctab)
	
	switch(ctab)
		case 2:		// switching to tab 2
			// hide prior controls
			ptab = "*_tab"+ptab
			tabList = ControlNameList(k_panelName,";",ptab)
			ModifyControlList tabList win=$k_fullpanel, disable=1
			break
		default:		// switching to any other tab
			switch(nptab)
				case 2:		// switch away from tab 2
					// hide tab 2 controls
					ptab = "*_tab"+ptab+"*"
					tabList = ControlNameList(k_panelName,";",ptab)
					ModifyControlList tabList win=$k_fullpanel, disable=1
					// show new tab controls
					ptab = "*_tab"+ctabstr
					tabList = ControlNameList(k_panelName,";",ptab)
					ModifyControlList tabList win=$k_fullpanel, disable=0			
					break
				default:		// switch away from any but 2 to any but 2
					// hide current tab controls
					ptab = "*_tab"+ptab
					tabList = ControlNameList(k_panelName,";",ptab)
					ModifyControlList tabList win=$k_fullpanel, disable=1
					// show new tab controls
					ptab = "*_tab"+ctabstr
					tabList = ControlNameList(k_panelName,";",ptab)
					ModifyControlList tabList win=$k_fullpanel, disable=0			
					break
			endswitch
			break
	endswitch

	// set current tab value
	TabControl tab_main,win=$k_panelName,userdata(ptab)=ctabstr
	
	// clean up controls in special cases
	disp_UpdatePanelControls(ctab)		
	
	ControlUpdate/A/W=$k_panelName

	return 0
end

// show a wave in the split window
Function disp_ShowinSplit(string wname)
	
	string dlist, sname
	variable which
	
	if (f_IsSplit())
		sname = StringFromList(1,ImageNameList(k_imgDisplay,";"))
		if (stringmatch(sname,"img_" + wname) == 1)
			return 0
		endif
	endif
	dlist = f_LoimgF()	
	which = WhichListItem(wname,dlist) + 2
	disp_SplitWindow(which)
	disp_UpdateControlBar()
	disp_UpdatePanelControls(-1)
	return 0
end

// split display windows
// which - which wave
Function disp_SplitWindow(variable which)
	
	DFREF pf=$k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile	
	
	string flist, dlist, tfile
	string wdf = "root:" + cwdfolder
	variable owidth, swidth, forig, how
	
	if (which < 0)
		ControlInfo/W=$k_imgDisplay popupSplit_CB
		which = v_value
	endif
	
	how = str2num(GetUserData(k_imgDisplay,"buttonSplitRoB_CB","mode"))
	
	switch(which)
		case 0:		// set for no split
		case 1:		// the NONE option in the menu input
			if (f_IsSplit())
				dlist = ImageNameList(k_imgDisplay,";")
				tfile = StringFromList(1,dlist)
				RemoveImage/W=$k_imgDisplay/Z $tfile
				ModifyGraph/W=$k_imgDisplay axisEnab(top)={0,1}
				ModifyGraph/W=$k_imgDisplay axisEnab(left)={0,1}
				//tfile = StringFromList(0,f_SplitOptions())
				PopupMenu popupSplit_CB, win=$k_imgDisplay, mode=1, value=f_SplitOptions(), userdata="None"
			endif
			break
		default:
			if (f_IsSplit())
				dlist = ImageNameList(k_imgDisplay,";")
				tfile = StringFromList(1,dlist)
				RemoveImage/W=$k_imgDisplay/Z $tfile
			endif
			flist = f_SplitOptions(full=1)
			tfile = StringFromList(which-1,flist)
			wave/SDFR=$wdf splitimg = $tfile
			switch(how)
				case 0:		// right
					owidth = f_ImageSize()[1]
					swidth = DimSize(splitimg,0)
					forig = 1 - swidth/(owidth+swidth)
					ModifyGraph/W=$k_imgDisplay height=0,width={Plan,1,top,left}
					AppendImage/W=$k_imgDisplay/T=splitT splitimg
					ModifyGraph/W=$k_imgDisplay axisEnab(top)={0,forig},axisEnab(splitT)={forig,1}
					ModifyGraph/W=$k_imgDisplay noLabel(splitT)=2,nticks(splitT)=0,freePos(splitT)=0
					break
				case 1:		// below
					owidth = f_ImageSize()[2]
					swidth = DimSize(splitimg,1)
					forig = 1 - swidth/(owidth+swidth)
					ModifyGraph/W=$k_imgDisplay width=0,height={Plan,1,left,top}
					AppendImage/W=$k_imgDisplay/L=splitL splitimg
					SetAxis/A/R splitL
					ModifyGraph/W=$k_imgDisplay axisEnab(splitL)={0,forig},axisEnab(left)={forig,1}
					ModifyGraph/W=$k_imgDisplay nticks(bottom)=0,freePos(splitL)=0
					ModifyGraph/W=$k_imgDisplay mirror(splitL)=2,nticks(splitL)=10,minor(splitL)=1,fSize(splitL)=9,noLabel=0,lblPos(splitL)=14,tkLblRot(splitL)=90,standoff=0,tlOffset(splitL)=-2
					break
			endswitch
			ControlInfo/W=$k_imgDisplay popupColor_CB
			ModifyImage $f_SplitWindowImage(), ctab={,,$s_value,0}
			if (f_IsStack())
				ModifyImage/W=$k_imgDisplay ''#1 plane=(f_PlaneNumber())
			endif
			PopupMenu popupSplit_CB, win=$k_imgDisplay, mode=1, value=f_SplitOptions(), userdata=tfile
			break
	endswitch	

	// if split, remove locked RoI
	if (f_IsSplit() && f_HasHRoI())
		lock_HistogramRoI(0)
		Checkbox checklockhRoI_tabM, win=$k_fullPanel, value=0, disable=2
	endif
	if (f_IsSplit() && f_HasMQ())
		update_MQCoordinates(1, killMQ=1)
	endif
	return 0
end

// function to update TabM
Function disp_UpdateTabM()

	DFREF pf=$k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable iwd, iwf, istack, shinfo, ninfoopts, pld = f_PlaneNumber(), dM
	string lowfolders = f_LoimgT()
	string lowfiles = f_LoimgF(sfolder=cwdfolder)

	// update list of folder sets and list of files in current folder
	iwd = WhichListItem(cwdfolder[5,inf],lowfolders)+1
	iwf = WhichListItem(cwfile[4,inf],lowfiles)+1
	lowfiles = "\"" + lowfiles + "\""
	dM = iwd < 1 ? 1 : 0
	
	// update folder and file popups
	PopupMenu popupfolder_tabM, win=$k_fullpanel, value=f_LoimgT(), mode=iwd, userData=cwdfolder, disable=dM
	PopupMenu popupfile_tabM, win=$k_fullpanel, value=#lowfiles, mode=iwf, userData=cwfile, disable=dM
	
	// handle cases for too few number of images loaded
	if (iwd == 0)
		Button/Z buttonleft_tabM, win=$k_fullpanel, disable=1
		Button/Z buttonright_tabM,win=$k_fullpanel, disable=1
	elseif (ItemsInList(f_LoimgT())<2)
		Button/Z buttonleft_tabM, win=$k_fullpanel, disable=2
		Button/Z buttonright_tabM,win=$k_fullpanel, disable=2
	elseif (iwd == 1)
		Button/Z buttonleft_tabM, win=$k_fullpanel, disable=2
		Button/Z buttonright_tabM,win=$k_fullpanel, disable=0
	elseif (iwd == ItemsInList(f_LoimgT()))
		Button/Z buttonleft_tabM, win=$k_fullpanel, disable=0
		Button/Z buttonright_tabM,win=$k_fullpanel, disable=2
	else
		Button/Z buttonleft_tabM, win=$k_fullpanel, disable=0
		Button/Z buttonright_tabM,win=$k_fullpanel, disable=0
	endif
	
	// update image size, note, and bit depth
	SetVariable setvarSize_tabM, win=$k_fullpanel, value=_STR:f_ImageSizeText()
	SetVariable setvarImgNote_tabM, win=$k_fullpanel, value=_STR:f_ImageNoteText()
	PopupMenu popupBitDepth_tabM,win=$k_fullpanel, mode=(f_PBitDepth()),value=#"f_LoBitDepths()"
	
	// information display	
	PopupMenu popupWhatInfo_tabM, win=$k_fullpanel, value=#"f_LoInfoOptions()" //, disable=dM
	ControlInfo/W=$k_fullPanel popupWhatInfo_tabM
	shinfo = v_value
	disp_UpdateInfo(shinfo)

	// update if stack or not
	if (f_IsStack())
		dM = 0
		istack = f_NImagesinStack() - 1
	else
		istack = 0
		dM = 1
	endif
	SetVariable setvarSN_tabM, win=$k_fullPanel, limits={0,istack,1}, value=_NUM:pld, disable=dM
	ValDisplay valdispNPlanes_TabM, win=$k_fullPanel, value=_NUM:iStack, disable=dM
	Button buttondoMovie_tabM, win=$k_fullPanel, disable=dM
	SetVariable setvarsleep_tabM, win=$k_fullPanel, disable=dM

	SetVariable setvarSize_tabM, win=$k_fullpanel, value=_STR:f_ImageSizeText()
	
#ifdef DEBUG
	print "updated Tab M"
#endif
	
	return 0
end

// update Info Window
Function disp_UpdateInfo(mode)
	variable mode
	
	string dtrace
	
	switch(mode)
		case 1:		// none
			Checkbox checklockhRoI_tabM, win=$k_fullPanel, disable=1
			TitleBox histscale_tabM,win=$k_fullPanel, disable=1
			Slider slidermagdhist_tabM, win=$k_fullPanel, disable=1
			ValDisplay valdispcx_tabM win=$k_fullPanel, disable=1
			ValDisplay valdispcy_tabM win=$k_fullPanel, disable=1
			Button buttonRedoH_tabM, win=$k_fullPanel, disable=1
			PopUpMenu popupMQProfile_tabM, win=$k_fullPanel, disable=1
			ValDisplay valdispmqdx_tabM, win=$k_fullpanel, disable=1
			ValDisplay valdispmqdxm_tabM, win=$k_fullpanel, disable=1
			ValDisplay valdispmqdy_tabM, win=$k_fullpanel, disable=1
			TitleBox histogramcursor_tabM, win=$k_fullpanel, disable=1
			disp_ShowHideHistograms(1)
			break
		case 2:		// histograms
			// handle case for marquee or HRoI
			if (f_HasMQ() || f_HasHRoI())
				PopupMenu popupHistRoI_tabM, win=$k_fullPanel, disable=0
				Checkbox checklockhRoI_tabM, win=$k_fullPanel, disable=0
			else
				PopupMenu popupHistRoI_tabM, win=$k_fullPanel, mode=1, disable=0, userdata="Full Image"
				Checkbox checklockhRoI_tabM, win=$k_fullPanel, disable=2
			endif
			ControlInfo/W=$k_fullpanel checklockhRoI_tabM
			TitleBox histscale_tabM,win=$k_fullPanel, disable=0
			TitleBox histogramcursor_tabM, win=$k_fullpanel, disable=0
			Slider slidermagdhist_tabM, win=$k_fullPanel, disable=0
			ValDisplay valdispcx_tabM win=$k_fullPanel, disable=0
			ValDisplay valdispcy_tabM win=$k_fullPanel, disable=0
			Button buttonRedoH_tabM, win=$k_fullPanel, disable=0
			PopUpMenu popupMQProfile_tabM, win=$k_fullPanel, disable=1
			ValDisplay valdispmqdx_tabM, win=$k_fullpanel, disable=1
			ValDisplay valdispmqdxm_tabM, win=$k_fullpanel, disable=1
			ValDisplay valdispmqdy_tabM, win=$k_fullpanel, disable=1
			// validate cursor is still on histogram graph
			DoWindow/F $k_histGraphs
			if (v_flag==0)
				disp_ShowHideHistograms(0)
			endif
//			dtrace = CsrInfo(A,k_histGraphs)
//			if (strlen(dtrace) == 0)
//				dtrace = StringFromList(3,TraceNameList(k_histGraphs,";",1))
//				Cursor/W=$k_histGraphs A $dtrace, 10
//			endif
//			disp_ShowHideHistograms(0)
			break		
		case 3:		// profiles
			break
	endswitch
	
	// update image intensity values
	
	STRUCT S_imgintensities sii
	Sf_Getimgintensities(sii)
	
	ValDisplay imin_tabM, win=$k_fullPanel, value=_NUM:sii.imin
	ValDisplay imax_tabM, win=$k_fullPanel, value=_NUM:sii.imax
	ValDisplay iave_tabM, win=$k_fullPanel, value=_NUM:sii.iave
	ValDisplay istd_tabM, win=$k_fullPanel, value=_NUM:sii.istd
	
	ValDisplay roimin_tabM, win=$k_fullPanel, value=_NUM:sii.roimin
	ValDisplay roimax_tabM, win=$k_fullPanel, value=_NUM:sii.roimax
	ValDisplay roiave_tabM, win=$k_fullPanel, value=_NUM:sii.roiave
	ValDisplay roistd_tabM, win=$k_fullPanel, value=_NUM:sii.roistd
	ValDisplay roitotal_tabM, win=$k_fullPanel, value=_NUM:sii.roitotal
	
	return 0
end

// update panel control displays and values for a given tab
Function disp_UpdatePanelControls(tab)
	variable tab
	
#ifdef DEBUG
	print "updating tab ", tab
#endif

	switch(tab)
		case -1:		// main (always present) content
			disp_updateTabM()
			break
		case 0:		// load tab
			disp_updateTab0()
			break
		case 1:		// calibrate tab
			disp_updateTab1()
			break
		case 2:		// process tab
			disp_updateTab2()
			break
		case 3:		// print tab
			disp_updateTab3()
			break
	endswitch
	
	return 0
end

// ***
// HOOK FUNCTIONS
// window, panel, histograms

// image window hook function
Function Hf_imgTImageHook(iwH)		// WindowHookFunction
	STRUCT WMWinHookStruct &iwH
	
	variable hookResult = 0, MQmoved
	string wmode
	
	switch(iwH.eventCode)
		case 0:		// activate
			// reset axes if ever switched
			wmode = GetUserData(k_imgDisplay,"","draw")
			if (strlen(wmode) != 0)
				// drawing mode active, ignore active event
#ifdef DEBUG
				GetWindow $k_imgDisplay drawlayer
				print "active: drawing mode active " + s_value
#endif
				hookResult = 0
			else
				hookResult = 1
			endif
			break
		case 2:		// image being killed
			KillWindow/Z $k_histGraphs
			hookResult = 1
			break
		case 5:		// mouseup - check for draw or marquee
#ifdef DEBUG
			print "mouseup on image"
#endif
			// is draw mode active?
			wmode = GetUserData(k_imgDisplay,"","draw")
			if (strlen(wmode) != 0)
				// drawing mode active
#ifdef DEBUG
				GetWindow $k_imgDisplay drawlayer
				print "mouseup: drawing mode active " + s_value
#endif
			else
				// not in drawing mode
				if (f_HasMQ())
					// kill marquee on split window or with HRoI
					if (f_IsSplit() || f_HasHRoI())
						SetMarquee/W=$k_imgDisplay 0,0,0,0
					else
						// has marquee been moved, created, or killed by mouseup?
						MQmoved = f_MQHasMoved()
						switch(MQmoved)
							case 1:	// moved or created
							case -1:	// killed from previous
								update_MQCoordinates(MQMoved)
								disp_UpdatePanelControls(-1)
								disp_UpdateHistograms()
								ControlInfo/W=$k_fullpanel tab_main
								if (v_value > 0)
									disp_UpdatePanelControls(v_value)
								endif
								DoWindow/F $k_imgDisplay
								break
						endswitch
					endif
				else
					// assure that marquee is removed (mouseup kills marquee)
					// has marquee been moved, created, or killed by mouseup?
					MQmoved = f_MQHasMoved()
					switch(MQmoved)
						case 1:	// moved or created
						case -1:	// killed from previous
							update_MQCoordinates(MQMoved)
							disp_UpdateHistograms()
							disp_UpdatePanelControls(-1)
							ControlInfo/W=$k_fullpanel tab_main
							if (v_value > 0)
								disp_UpdatePanelControls(v_value)
							endif
							DoWindow/F $k_imgDisplay
							break
					endswitch
				endif
			endif
			if (strlen(GetUserData(k_imgDisplay,"","lineprofile"))!=0)
//				update_lpcursors()
//				print "line profile active"
			endif
			hookResult = 1
			break
	endswitch
	
	return hookResult
end

// panel hook function
Function Hf_imgTPanelHook(ipH)		// WindowHookFunction
	STRUCT WMWinHookStruct &ipH
	
	variable hookResult = 0, il, ctab, pA, pB
	
	switch(ipH.eventCode)
		case 5:		// panel update on mouseup event
			GetWindow $k_fullpanel needupdate
			if (!v_value)
				break
			endif
			ControlInfo/W=$k_fullpanel tab_main
			ctab = v_value
#ifdef DEBUG
			print "active at tab", ctab
#endif			
			disp_UpdatePanelControls(-1)
			disp_UpdatePanelControls(ctab)
			ControlInfo/W=$k_fullpanel mqx0_tabM
			if (!f_HasMQ() && (numtype(v_value) != 2))
				// marquee disappeared in the mean time
				update_MQCoordinates(0,killMQ=1)
			//	reset_MQCoordinates()
			endif
			SetWindow $k_fullPanel needUpdate=0
			hookResult = 1
			break
		case 2:		// panel being killed
			KillWindow/Z $k_histGraphs
			KillWindow/Z $k_imgDisplay
			hookResult = 1
			break
	endswitch
#ifdef DEBUG
	print "panel hook: ", ipH.eventCode, hookResult
#endif
	return hookResult	
end

// histogram window hook function
Function Hf_imgTHistogramsHook(igH)		// WindowHookFunction
	STRUCT WMWinHookStruct &igH
	
	variable hookResult = 0, iclow, ichigh, bd
	string dtrace

	switch(igH.eventCode)
		case 7:		// cursor moved
#ifdef DEBUG
			print "cursor moved on histograms"
#endif
			GetWindow/Z $k_panelName exterior
			if (v_value==1)
#ifdef DEBUG
				print "setting cursor display values on panel: ", xcsr(A,k_histGraphs)
#endif
				// confirm cursor is still on graph
				dtrace = CsrInfo(A,k_histGraphs)
				if (strlen(dtrace) == 0)
					dtrace = StringFromList(3,TraceNameList(k_histGraphs,";",1))
					Cursor/W=$k_histGraphs A $dtrace, 10
				endif
				ValDisplay valdispcx_tabM, win=$k_panelName, value=_NUM:xcsr(A,k_histGraphs)
				ValDisplay valdispcy_tabM, win=$k_panelName, value=_NUM:vcsr(A,k_histGraphs)
			endif
			
			hookresult = 1
			break
	endswitch
	
	return hookResult
end

// ***
// SUPPORTING STATIC
// play fast movie
// reset image folder
// validate axes
// set image to show
// reset image file on panel
// clean up display windows
// validate marquee coordinates

// play fast movie
Static Function play_fastMovie()

	// globals for package	
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable ic, nimgs, isSplit
	string fstr = f_SplitWindowImage()

	nimgs = f_NImagesinStack()
	isSplit = f_IsSplit()
	
	for (ic=0;ic<nimgs;ic+=1)
		ModifyImage/W=$k_imgDisplay $cwfile, plane=ic
		if (isSplit == 1)
			ModifyImage/W=$k_imgDisplay $fstr, plane=ic
		endif
		DoUpdate/W=$k_imgDisplay
	endfor
	return 0
end

// reset image folder (change value only)
Static Function reset_ImageFolder(fnum)
	variable fnum
	
	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	// reset the global folder
	string flist = f_LoimgT()
	
	flist = f_LoimgT()
	cwdfolder = "imgT_" + StringFromList(fnum-1,flist,";")
	
	// reset the file to the first one in the folder when needed
	flist = f_LoimgF(sfolder=cwdfolder)
	fnum = WhichListItem(cwfile[4,inf],flist)
	if (fnum < 0)
		cwfile = "img_" + StringFromList(0,f_LoimgF(sfolder=cwdfolder),";")
	else
		cwfile = "img_" + StringFromList(fnum,flist)
	endif
	
#ifdef DEBUG
	print "reset image folder/file ", cwdfolder, cwfile
#endif

	return 0
end

// validate image axes (force autoscale)
Static Function validate_ITAxes([variable autoscale)

	if (!ParamIsDefault(autoscale))
		SetAxis/W=$k_imgDisplay/A/R left
		SetAxis/W=$k_imgDisplay/A/R top
		return 0
	endif
			
	// left axis must be min > max
	GetAxis/W=$k_imgDisplay/Q left
	if (v_max > v_min)
		SetAxis/W=$k_imgDisplay/A/R left
	endif
	GetAxis/W=$k_imgDisplay/Q top
	if (v_min > v_max)
		SetAxis/W=$k_imgDisplay/A/R top
	endif
	return 0
end

// fill the folder + file structure manually
// pass paramters with prefixes!!!
Static Function set_ImagetoShow(string sfolder, string sfile)
	
	// globals for package	
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	string flist
	variable itn
	
	// set the folder
	cwdfolder = sfolder	
	flist = f_LoimgT()
	itn = WhichListItem(sfolder[5,inf],flist) + 1	
	Popupmenu popupfolder_tabM, win=$k_fullpanel, mode=itn, value=f_LoImgT()
	
	// set the file
	cwfile = sfile
	flist = f_LoimgF()
	itn = WhichListItem(sfile[4,inf],flist) + 1
	Popupmenu popupfile_tabM, win=$k_fullpanel, mode=itn, value=f_LoimgF()
	
	return 0
end

// reset image file on panel
Static Function reset_ImageFileonPanel()
	
	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable fnum
	string flist = f_LoimgF(), ffile

	// reset the file
	ffile = cwfile[4,inf]
	fnum = WhichListItem(ffile,flist)
	PopupMenu popupfile_tabM, win=$k_fullpanel, mode=fnum+1, popvalue=ffile
	SetVariable setvarImgNote_tabM, win=$k_fullpanel, value=_STR:f_ImageNoteText()
	SetVariable setvarSize_tabM,win=$k_fullpanel, value=_STR:f_ImageSizeText()
	return 0
end

// restore image settings (when tab side is changed)
Static Function restore_ImageSettings(scb)
	Struct S_ControlBarSettings &scb
	
	variable pv
	// color
	ModifyImage $f_CurrentImage(), ctab={,,$scb.colorstr,0}
	if (f_isSplit())
		ModifyImage $f_SplitWindowImage(), ctab={,,$scb.colorstr,0}
	endif
	
	// inversion
	Change_DisImageBitDepth(0)
	
	// max/min range
	pv = Change_DisImageBitDepth(-1)
	move_HistCursor(-1,pv)
	pv = Change_DisImageBitDepth(1)
	move_HistCursor(1,pv)

	return 0
end

// clean up display windows
Static Function cleanup_ImageDisplay()

	if (f_HasHRoI())
		lock_HistogramRoI(-1)
	endif
	if (f_HasMQ())
		update_MQCoordinates(0, killMQ=1)
	endif
	if (f_HasBckgMrkrs())
		T21_ClearBackgroundPoints()
	endif
	return 0
end

// confirm marquee is within image coordinates
// reset if required
Static Function validate_MQCoordinates()

	variable flag = 0, msize

	STRUCT S_ImgDimensions sid	
	Sf_GetImgDimensions(sid)
	STRUCT S_MarqueeCoordinates mc
	Sf_GetMQCoordinates(mc)
	
	// check if over image dimensions
	if (mc.pgrleft < sid.left)
		SetVariable mqx0_tabM, win=$k_panelName, value=_NUM:sid.left
		flag = 1
	endif
	if (mc.pgrright > sid.right)
		msize = sid.right - mc.pgrleft
		SetVariable mqdx_tabM, win=$k_panelName, value=_NUM:msize
		flag = 1
	endif
	if (mc.pgrtop < sid.top)
		SetVariable mqy0_tabM, win=$k_panelName, value=_NUM:sid.right
		flag = 1
	endif
	if (mc.pgrbottom > sid.bottom)
		msize = sid.bottom - mc.pgrtop
		SetVariable mqdy_tabM, win=$k_panelName, value=_NUM:msize
		flag = 1
	endif
	
	if (flag)
//		DoUpdate/W=$k_fullpanel
		change_MQfromPanel()
	endif	

	return flag
end

// ***
// SUPPORTING GLOBAL
// show an image
// step thru images
// play fast movie
// swap split images
// reset image file name
// play stack
// lock histogram RoI
// move histogram cursors
// update marquee coordinates
// change image bit depth
// rescale image bit depth
// set a note

// show an image
Function show_AnImage([plane,reset])
	variable plane,reset

	// globals for package	
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	string fstr, tstr
//	variable bd
//	bd = f_ImageBitDepth()
	
	// just moving to new plane
	if (!ParamIsDefault(plane) && (ParamIsDefault(reset)))
		ModifyImage/W=$k_imgDisplay $cwfile, plane=plane
		fstr = f_SplitWindowImage()
		if (strlen(fstr)!=0)
			ModifyImage/W=$k_imgDisplay $fstr, plane=plane
		endif
		return 0
	endif

#ifdef DEBUG
	print "Showing an image ", cwfile
#endif
	
	// set the folder and new image to display
	fstr = "root:" + cwdfolder
	DFREF imgF = $fstr	
	wave/SDFR=imgF itd=$cwfile
	
	tstr = StringFromList(0,(ImageNameList(k_imgDisplay,";")))
	ReplaceWave/W=$k_imgDisplay image=$tstr, itd
	
	fstr += ":" + cwfile
	if (f_isStack())
		if (ParamIsDefault(plane))
			ModifyImage/W=$k_imgDisplay $cwfile, plane=f_PlaneNumber()
		else
			ModifyImage/W=$k_imgDisplay $cwfile, plane=plane
		endif
	endif
	
	disp_ShowScaleBar(0)
	DoUpdate/W=$k_imgDisplay
	ControlInfo/W=$k_fullPanel popupScaleBar_tab3
	if (v_value  > 1)
		disp_ShowScaleBar(v_value - 1)
	endif
	
	disp_UpdateControlBar()
	change_DisImageBitDepth(2)
	validate_ITAxes()
	//DoUpdate
	return 0
end

// step thru images
// -1 back; 0 stay; 1 forward
Function step_ThruImages(how,[plane])
	variable how, plane
	
	string sfolders = f_LoimgT()
	variable nfolders = ItemsInList(sfolders), itd
	variable nimgs, nplane
	variable oldisize, newisize

#ifdef DEBUG
	print "Stepping through images ", how
#endif
	
	// which folder is current?
	ControlInfo/W=$k_fullpanel popupFolder_tabM
	itd = v_value
	
	oldisize = f_ImageSize()[6]+f_ImageSize()[1]

	// switch planes only?
	if (ParamIsDefault(plane))
		switch(how)
			case -1:		// step back one folder
				if (itd == 1)
					return 0
				endif
				reset_ImageFolder(itd-1)
				break
			case 0:		// new or same folder
				reset_ImageFolder(itd)
				break
			case 1:		// step forward one folder
				if (itd == nfolders)
					return 0
				endif
				reset_ImageFolder(itd+1)
				break
		endswitch
		// have we switched to an image stack?
		if (f_IsStack())
			// reset the stack plane position
			nimgs = f_NImagesinStack()
			ValDisplay valdispNPlanes_TabM, win=$k_fullpanel, value=_NUM:(nimgs-1)
			ControlInfo/W=$k_fullpanel setvarSN_TabM
			if (v_value > nimgs-1)
				SetVariable setvarSN_TabM, win=$k_fullpanel, value=_NUM:(nimgs-1)
				show_AnImage(plane=(nimgs-1),reset=1)
			else
				show_AnImage(plane=v_value,reset=1)
			endif
		else
			show_AnImage()
		endif
		// (re)set the new calibration
		T1_ReSetXY()
	else
		show_AnImage(plane=plane)
	endif

	// adjust image bitdepth to new image
	Change_DisImageBitDepth(2)
	Change_DisImageBitDepth(0)
	
	// clean up if image size (width x height) + width is different
	newisize = f_ImageSize()[6]	+f_ImageSize()[1]
	if (newisize != oldisize)
		cleanup_ImageDisplay()
	endif
	
	disp_ShowHistograms(1)

#ifdef DEBUG
	print "Done stepping through images ", how
#endif

	return 0
end

// swap images in split view
Function swap_SpitViewImages()

	string dmimg, dsimg, timg
	variable owidth, swidth, forig
	variable mode
	
	if (f_IsSplit() == 0)
		return -1
	endif
	mode = str2num(GetUserData(k_imgDisplay,"buttonSplitRoB_CB","mode"))
	
	// main and split names
	dmimg = StringFromList(0,ImageNameList(k_imgDisplay,";"))
	dsimg = StringFromList(1,ImageNameList(k_imgDisplay,";"))
	// main and split waves
	wave wmimg = $(f_displayImageID(3))
	wave wsimg = $(f_displayImageID(4))
	
	owidth = DimSize(wsimg,mode)
	swidth = DimSize(wmimg,mode)
	forig = 1 - (swidth/(swidth + owidth))
	// create temporary from split
	timg = dsimg + "_tmp"
	duplicate/O wsimg $timg
	wave wtimg = $timg
	// swap split<-tmp, main<-split, split<-main
	ReplaceWave/W=$k_imgDisplay image=$dsimg, wtimg
	ReplaceWave/W=$k_imgDisplay image=$dmimg, wsimg
	ReplaceWave/W=$k_imgDisplay image=$timg, wmimg
	if (mode == 0)
		ModifyGraph/W=$k_imgDisplay axisEnab(top)={0,forig},axisEnab(splitT)={forig,1}
	else
		ModifyGraph/W=$k_imgDisplay axisEnab(splitL)={0,forig},axisEnab(left)={forig,1}	
	endif
	killwaves/Z wtimg
	
	if (f_isStack())
		ModifyImage/W=$k_imgDisplay $dmimg, plane=f_PlaneNumber()
		ModifyImage/W=$k_imgDisplay $dsimg, plane=f_PlaneNumber()		
	endif
	DoUpdate/W=$k_imgDisplay

	Reset_CWImageFileName(ReplaceString("img_",dsimg,""))
	//TM_StepThruImages(0)
	
	disp_UpdateControlBar()
	disp_UpdatePanelControls(-1)
	change_DisImageBitDepth(2)
	ControlInfo/W=$k_fullpanel tab_main
	disp_UpdatePanelControls(v_value)
	disp_UpdateHistograms()
	T3_UpdateContactPrint()
	return 0
end

// reset image file (change value only)
Function reset_CWImageFileName(fname)
	string fname
	
	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwfile

	cwfile = "img_" + fname
	//SetVariable setvarCurrImg_CB, win=$k_imgDisplay, value=_STR:fname
	return 0
end	

// play movie for stack
Function play_Stack(slt)
	variable slt

	variable ic, ni, logni, cplane

	if (!f_isStack())
		return 0
	endif
	
	ni = f_NImagesinStack()
	cplane = f_PlaneNumber()
	logni = round(log(ni))
	
#ifdef DEBUG
	print "playing a movie: ", slt
#endif
//	DoWindow/F $k_imgDisplay
//	DoUpdate
	
	try
		if (slt == 0)
			play_fastMovie()
		else
			for (ic=0;ic<ni;ic+=1)
				show_AnImage(plane=ic)
				DoUpdate/W=$k_imgDisplay
				SetVariable setvarSN_TabM, win=$k_fullPanel, value=_NUM:ic
				Sleep/T/Q slt
			endfor
		endif
		show_AnImage(plane=cplane)
		DoUpdate/W=$k_imgDisplay
		SetVariable setvarSN_TabM, win=$k_fullPanel, value=_NUM:cplane
	catch
		SetVariable setvarSN_TabM, win=$k_fullPanel, value=_NUM:(ic-1)
		step_ThruImages(0,plane=(ic-1))
	endtry
	
	// return focus to panel after running movie
	DoWindow/F $k_panelName
	return 0
end

// move histogram cursors for range
Function move_HistCursor(which,xpntset)
	variable which, xpntset
	
	string dtrace
	variable xend

	// fix if histogram window has been deleted
	DoWindow $k_histGraphs
	if (v_flag == 0)
		disp_ShowHistograms(0)
	endif
	
	switch(which)
		case -1:		// left
			dtrace = CsrWave(C,k_histgraphs,1)
			Cursor/W=$k_histgraphs C $dtrace, xpntset
			break
//		case 0:		// both
//			wave dwave = CsrWaveRef(C,k_histGraphs)
//			xend = numpnts(dwave) - 1
//			dtrace = CsrWave(C,k_histgraphs,1)
//			Cursor/P/W=$k_histgraphs C $dtrace, 0
//			Cursor/P/W=$k_histgraphs D $dtrace, xend
//			break
		case 1:		// right
			dtrace = CsrWave(D,k_histgraphs,1)
			Cursor/W=$k_histgraphs D $dtrace, xpntset
			break
	endswitch
	Cursor/M/A=0/W=$k_histgraphs C
	Cursor/M/A=0/W=$k_histgraphs D
	return 0
end

// lock the histogram to a RoI
Function lock_HistogramRoI(variable yn)

	variable hq, ppx0, ppx1, ppy0, ppy1
	STRUCT S_MarqueeCoordinates mc

	switch(yn)
		case -1:		// unlock and remove
			hq = Sf_GetHRoICoordinates(mc)
			if (hq==-1)
				return -1
			endif
			SetDrawLayer/W=$k_imgDisplay ProgFront
			DrawAction/W=$k_imgDisplay getgroup=hRoI, delete
			SetDrawLayer/W=$k_imgDisplay UserFront
			SetVariable mqx0_tabM, win=$k_fullpanel, value=NaN, disable=2
			SetVariable mqdx_tabM, win=$k_fullpanel, value=NaN, disable=2
			SetVariable mqy0_tabM, win=$k_fullpanel, value=NaN, disable=2
			SetVariable mqdy_tabM, win=$k_fullpanel, value=NaN, disable=2
			CheckBox checklockhRoI_tabM, win=$k_fullpanel, value=0, disable=2
			break
		case 0:		// unlock
			hq = Sf_GetHRoICoordinates(mc)
			if (hq==-1)
				return -1
			endif
			SetDrawLayer/W=$k_imgDisplay ProgFront
			DrawAction/W=$k_imgDisplay getgroup=hRoI, delete
			SetDrawLayer/W=$k_imgDisplay UserFront
			SetMarquee/W=$k_imgDisplay, mc.ppleft,mc.pptop,mc.ppright,mc.ppbottom
			SetVariable mqx0_tabM, win=$k_fullpanel, disable=0
			SetVariable mqdx_tabM, win=$k_fullpanel, disable=0
			SetVariable mqy0_tabM, win=$k_fullpanel, disable=0
			SetVariable mqdy_tabM, win=$k_fullpanel, disable=0
			update_MQCoordinates(0)
			break
		case 1:		// lock
			hq = Sf_GetMQCoordinates(mc)
			if (hq==-1)
				return -1
			endif
			// put rounded pixel coordinates in local variables
			ppx0 = mc.pgrleft
			ppy0 = mc.pgrtop
			ppx1 = mc.pgrright
			ppy1 = mc.pgrbottom
			SetDrawLayer/W=$k_imgDisplay ProgFront
			SetDrawEnv/W=$k_imgDisplay gstart,gname=hRoI
			SetDrawEnv/W=$k_imgDisplay linefgc=(65535,0,0),linethick=2,fillpat=0, xcoord=top,ycoord=left, save
			DrawRect/W=$k_imgDisplay ppx0,ppy0,ppx1,ppy1
			SetDrawEnv/W=$k_imgDisplay gstop
			SetDrawLayer/W=$k_imgDisplay UserFront
			SetVariable mqx0_tabM, win=$k_fullpanel, disable=2
			SetVariable mqdx_tabM, win=$k_fullpanel, disable=2
			SetVariable mqy0_tabM, win=$k_fullpanel, disable=2
			SetVariable mqdy_tabM, win=$k_fullpanel, disable=2
			SetMarquee/W=$k_imgDisplay 0, 0, 0, 0
			break
	endswitch

#ifdef DEBUG	
	print mc
#endif

	return 0
end

// reset marquee coordinates because panel input has changed them
Function change_MQfromPanel()

	variable mqleft, mqtop, mqright, mqbottom
	variable aleft, awidth, atop, aheight
	variable marginl, margint, pxleft, pxtop
	variable pxlsh, pntsh, pntsppxl, ex, how

	STRUCT S_ImgDimensions sid	
	Sf_GetImgDimensions(sid)

	// update marquee with panel inputs
	
	// points per pixel and image margin
	GetWindow $k_imgDisplay, axsizeDC
	pxlsh = V_right - V_left
	marginl = v_left
	margint = v_top
	GetWindow $k_imgDisplay, axsize
	pntsh = V_right - V_left
	pntsppxl = pntsh / pxlsh
	GetWindow $k_imgDisplay wsizeDC
	marginl -= v_left
	margint -= v_top
	
	GetWindow $k_imgDisplay expand
	ex = v_value == 0 ? 1 : v_value
	
	pxleft = PixelFromAxisVal(k_imgDisplay,"left",sid.left)
	pxtop = PixelFromAxisVal(k_imgDisplay,"top",sid.top)
	
	ControlInfo/W=$k_panelName mqx0_tabM
	aleft = v_value
	if (aleft < sid.left)
		aleft = sid.left
		SetVariable mqx0_tabM, win=$k_panelName, value=_NUM:aleft
	endif
	mqleft = ex*((PixelFromAxisVal(k_imgDisplay,"left",aleft) - pxleft)*pntsppxl) + marginl
	ControlInfo/W=$k_panelName mqy0_tabM
	atop = v_value
	if (atop < sid.top)
		atop = sid.top
		SetVariable mqy0_tabM, win=$k_panelName, value=_NUM:atop
	endif
	mqtop = ex*((PixelFromAxisVal(k_imgDisplay,"top",atop) - pxtop)*pntsppxl) + cbheight + margint
	ControlInfo/W=$k_panelName mqdx_tabM
	awidth = v_value
	if ((aleft + awidth) > sid.right)
		awidth = sid.right - aleft
		SetVariable mqdx_tabM, win=$k_panelName, value=_NUM:awidth
	endif		
	mqright = ex*((PixelFromAxisVal(k_imgDisplay,"left",aleft + awidth) - pxleft)*pntsppxl) + marginl
	ControlInfo/W=$k_panelName mqdy_tabM
	aheight = v_value
	if ((atop + aheight) > sid.bottom)
		aheight = sid.bottom - atop
		SetVariable mqdy_tabM, win=$k_panelName, value=_NUM:aheight
	endif		
	mqbottom = ex*((PixelFromAxisVal(k_imgDisplay,"top",atop + aheight) - pxtop)*pntsppxl) + cbheight + margint

	SetMarquee/W=$k_imgDisplay mqleft, mqtop, mqright, mqbottom

#ifdef DEBUG	
	print mqleft, mqtop, mqright, mqbottom
	STRUCT S_MarqueeCoordinates mc
	Sf_GetMQCoordinates(mc)
	print mc
#endif
	
	return 0
end

// update marquee coordinates on panel
Function update_MQCoordinates(variable MQmoved, [variable killMQ])

	variable rtn = 0
	STRUCT S_MarqueeCoordinates mc
	
	if (ParamIsDefault(killMQ))
		// no kill event
		switch(MQmoved)
			case -1:		// killed (at mouseup)
				SetVariable mqx0_tabM, win=$k_fullpanel, disable=2, value=_NUM:NaN
				SetVariable mqdx_tabM, win=$k_fullpanel, disable=2, value=_NUM:NaN
				SetVariable mqy0_tabM, win=$k_fullpanel, disable=2, value=_NUM:NaN
				SetVariable mqdy_tabM, win=$k_fullpanel, disable=2, value=_NUM:NaN
				CheckBox checklockhRoI_tabM, win=$k_fullpanel, disable=2
				SetWindow $k_imgDisplay userData(MQsize)=""
				rtn = -1
				break
			case 0:		// no change
				break
			case 1:		// moved
				validate_MQCoordinates()
				Sf_GetMQCoordinates(mc)
				SetVariable mqx0_tabM, win=$k_fullpanel, disable=(2*!mc.hasmarquee), value=_NUM:mc.pgrleft
				SetVariable mqdx_tabM, win=$k_fullpanel, disable=(2*!mc.hasmarquee), value=_NUM:(mc.pgrright - mc.pgrleft)
				SetVariable mqy0_tabM, win=$k_fullpanel, disable=(2*!mc.hasmarquee), value=_NUM:mc.pgrtop
				SetVariable mqdy_tabM, win=$k_fullpanel, disable=(2*!mc.hasmarquee), value=_NUM:(mc.pgrbottom - mc.pgrtop)
				CheckBox checklockhRoI_tabM, win=$k_fullpanel, disable=(2*!mc.hasmarquee)
				SetWindow $k_imgDisplay userData(MQsize)=mc.pgsize
				break
		endswitch
	else
		// kill event requested
		SetMarquee/W=$k_imgDisplay 0,0,0,0
		SetVariable mqx0_tabM, win=$k_fullpanel, disable=2, value=_NUM:NaN
		SetVariable mqdx_tabM, win=$k_fullpanel, disable=2, value=_NUM:NaN
		SetVariable mqy0_tabM, win=$k_fullpanel, disable=2, value=_NUM:NaN
		SetVariable mqdy_tabM, win=$k_fullpanel, disable=2, value=_NUM:NaN
		CheckBox checklockhRoI_tabM, win=$k_fullpanel, disable=2
		SetWindow $k_imgDisplay userData(MQsize)=""
		rtn = -1
	endif

	return rtn
end

// how -1 min, 1 max
// which 0 slider, 1 setvar
Static Function get_DisImageMinMax(variable how, variable which)

	variable vrtn, sval, bd = f_ImageBitDepth(), dmax
	switch(how)
		case -1:		// min
			if (which == 0)
				ControlInfo/W=$k_imgDisplay sliderIMin_CB
				sval = v_value
			else
				ControlInfo/W=$k_imgDisplay setvarIMin_CB
				sval = v_value
			endif
			break
		case 1:		// max
			if (which == 0)
				ControlInfo/W=$k_imgDisplay sliderIMax_CB
				sval = v_value
			else
				ControlInfo/W=$k_imgDisplay setvarIMax_CB
				sval = v_value
			endif
			break
	endswitch
	if (which == 0)			// slider
		ControlInfo/W=$k_imgDisplay checkMaxRange_CB
		if (v_value)
			dmax = f_DisplayedImageMax()
		else
			dmax = 2^bd - 1
		endif
	else
		dmax = 1
	endif
	vrtn = sval*dmax
	return vrtn
end

// change bit depth
// -2 bw, -1 min, 0 invert, 1 max, 2 min + max
// fraction of image bit depth
Function change_DisImageBitDepth(variable minmax)

	// globals for package	
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable bd, slval, dmax, bntset, pntset, isSplit, usesv
	
	ControlInfo/W=$k_imgDisplay checkNumbers_CB
	usesv = v_value
	
	isSplit = f_IsSplit()
	bd = f_ImageBitDepth()

	switch(minmax)
		case -2:		// monochrome onoff (checkbox action)
			ControlInfo/W=$k_imgDisplay checkBW_CB
			ModifyImage/W=$k_imgDisplay $cwfile, explicit=v_value
			if (isSplit)
				cwfile = StringFromList(1,ImageNameList(k_imgDisplay,";"))
				ModifyImage/W=$k_imgDisplay $cwfile, explicit=v_value			
			endif
			break
		case -1:		// change min (slider action)
			pntset = Get_DisImageMinMax(-1, usesv)
			ModifyImage/W=$k_imgDisplay $cwfile, ctab={pntset,,,0}
			break
		case 0:		// invert (checkbox action)
			ControlInfo/W=$k_imgDisplay checkInvert_CB
			ModifyImage/W=$k_imgDisplay $cwfile, ctab={,,,v_value}
			break
		case 1:		// change max (slider action)
			pntset = Get_DisImageMinMax(1, usesv)
			ModifyImage/W=$k_imgDisplay $cwfile, ctab={,pntset,,0}
			break
		case 2:		// change min + max
			bntset = Get_DisImageMinMax(-1, usesv)
			pntset = Get_DisImageMinMax(1, usesv)
			ModifyImage/W=$k_imgDisplay $cwfile, ctab={bntset,pntset,,0}
			break
	endswitch
	
	return pntset
end

// upscale image bit depth
Function rescale_BitDepth(variable ndb)

	DFREF pf = $k_fullpackagefolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	DFREF cdf = GetDataFolderDFR()
	
	SetDataFolder $("root:" + cwdfolder)
	
	wave img = $cwfile
	
	switch(ndb)
		case 2:	// 16 bit
			Redimension/W img
			break
		case 3:	// 32 bit
			Redimension/S img
			break
		case 4:	// 64 bit
			Redimension/D img
			break
	endswitch
	
	SetDataFolder cdf
	
	return 0
end

// set image note
Function set_ImageNote()

	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string rtstr = ""
	string wname = "root:" + cwdfolder + ":" + cwfile

	ControlInfo/W=$k_fullpanel setvarImgNote_tabM
	rtstr = s_value
	Note/K $wname
	Note $wname, rtstr
	
	// update contact print with new note
	ControlInfo/W=$k_fullpanel checkCP_tab3
	if (v_value)
		T3_StoreasContactPrint()
	endif

	return 0
end


// ***
// SUPPORT FUNCTIONS

// ***
// GENERAL PURPOSE

// print operation to notebook
//Function imgT_PrintReport(cmd,ptxt,pvals,[image])
Function print_imgTReport()
	
	DFREF pf = $k_fullpackageFolder
	wave/T/SDFR=pf ptxt
	wave/SDFR=pf pvals
	
	string pstr=""
	variable ic, nvals, iwidth, sfp
	
	if (!f_printNtbk())
		return 0
	endif
	
	DoWindow/F imgT_FNotebook
	if (!v_flag)
		NewNotebook/N=imgT_FNotebook/F=1/K=3/OPTS=(4+8) as "Image Tools Notebook"
		pstr = "Image Tools Notebook\r--\r"
	else
		Notebook imgT_FNotebook, selection={endOfFile,endOfFile}
	endif	
	pstr += f_DateTimeStamp() + " - " + ptxt[0]
	
	nvals = DimSize(pvals,0)
	
	if (nvals != 0)
		for (ic=0;ic<nvals;ic+=1)
			pstr += "\r" + ptxt[ic+1] + ": " + num2str(pvals[ic])
		endfor
	endif	
	
	pstr += "\r"
	
	//Notebook imgT_Notebook, selection={endOfFile,endOfFile}, writeProtect=1
	Notebook imgT_FNotebook, text=pstr
	GetWindow $k_imgDisplay wsize
	iwidth = v_right-v_left
	sfp = 100*(250/iwidth)
	Notebook imgT_FNotebook scaling={sfp,sfp}, picture={$k_imgDisplay,-5,1,1}
	Notebook imgT_FNotebook, text="\r"
	return 0
end

// open help file
Function open_ImgToolsHelp(string htitle)

	string strfn, htopic
	htopic = "Image Tools " + htitle
	sprintf strfn, "%s:Image Tools Help.ifn", ParseFilePath(1,FunctionPath(""), ":",1,0)
	OpenHelp/INT=0/Z strfn
	DisplayHelpTopic/Z htopic
	
	return 0
end

Function toggle_DisplaySize(ba)
	STRUCT WMButtonAction &ba

	variable how, shiftkey, axheight, axwidth, size
	string tstr, uDStrstate, uDstrsize
	
	how = str2num(GetUserData(k_imgDisplay,"buttonExpand_CB","state"))
	size = str2num(GetUserData(k_imgDisplay,"buttonExpand_CB","size"))
	shiftkey = ba.eventMod == 2 ? 1 : 0
	
	uDstrsize = num2str(size)
	// -1 - control bar -> free or preferred, 0 - free -> control bar, 1 - preferred -> control bar
	switch(how)
		case -1:		// control bar, switch to free or preferred
			if (size > 0)
				ModifyGraph/W=$k_imgDisplay width={Plan,1,top,left}, height=size
				tstr = "[ ]"
				uDstrstate = "1"
			else
				ModifyGraph/W=$k_imgDisplay width={Plan,1,top,left}, height=0
				tstr = "..."
				uDstrstate = "0"
			endif
			break
		case 0:		// free, store size or switch to size for control bar
			if (shiftkey)
				GetWindow $k_imgDisplay axsize
				axheight = v_bottom - v_top
				ModifyGraph/W=$k_imgDisplay width={Plan,1,top,left}, height=axheight
//				DoUpdate/W=$k_imgDisplay
//				ModifyGraph/W=$k_imgDisplay width={Plan,1,top,left}, height=0
				tstr = "[ ]"
				uDstrstate = "1"
				uDstrsize = num2str(axheight)
			else
				GetWindow $k_imgDisplay axsize
				axwidth = v_right - v_left
				if (axwidth != 560)
					ModifyGraph/W=$k_imgDisplay width=560, height={Plan,1,left,top}
					DoUpdate/W=$k_imgDisplay
					ModifyGraph/W=$k_imgDisplay width={Plan,1,top,left}, height=0
				endif
				tstr = "[..]"
				uDstrstate = "-1"
			endif
			break
		case 1:		// preferred, unlock or switch to size for control bar
			if (shiftkey)
				ModifyGraph/W=$k_imgDisplay width={Plan,1,top,left}, height=0
				tstr = "..."
				uDstrstate = "0"
				uDstrsize = "0"
			else
				GetWindow $k_imgDisplay axsize
				axwidth = v_right - v_left
				if (axwidth != 560)
					ModifyGraph/W=$k_imgDisplay width=560, height={Plan,1,left,top}
					DoUpdate/W=$k_imgDisplay
					ModifyGraph/W=$k_imgDisplay width={Plan,1,top,left}, height=0
				endif
				tstr = "[..]"
				uDstrstate = "-1"
			endif
			break
	endswitch
	
	Button buttonExpand_CB, win=$k_imgDisplay, title=tstr, userData(state)=uDstrstate, userData(size)=uDstrsize
	return 0
end
